<?php
/*
Plugin Name: Upcoming Posts
Description: Display a list of upcoming scheduled posts.
Version: 1.0
Author: Fabio Huwyler
*/

function upcoming_posts_shortcode($atts) {
    global $post;

    // Merge given attributes with default attributes
    $attributes = shortcode_atts(
        array(
            'numberposts' => 5, // Default number of posts to display
        ), $atts
    );

    // Arguments to fetch future posts
    $args = array(
        'post_status' => 'future',
        'orderby' => 'date',
        'order' => 'ASC',
        'posts_per_page' => $attributes['numberposts'],
    );

    $upcoming_posts = get_posts($args);

    // Check if there are no upcoming posts
    if (empty($upcoming_posts)) {
        return '<p>No upcoming posts are scheduled at this time.</p>';
    }
    
    $output = '<ul class="upcoming-posts">';

    foreach ($upcoming_posts as $post) {
    setup_postdata($post);
    $output .= '<li>';
    $output .= '<strong>' . get_the_title($post) . '</strong> - ' . get_the_date('', $post);
    $output .= '<p>' . get_the_excerpt($post) . '</p>';
    $output .= '</li>';
}

    $output .= '</ul>';

    wp_reset_postdata();

    return $output;
}


add_shortcode('upcoming_posts', 'upcoming_posts_shortcode');

?>
